function parameters = set_parameters
% This function sets all parameters for vectorial PSF calculations

% parameters: NA, refractive indices of medium, cover slip, immersion fluid,
% nominal value of immersion fluid refractive index matching objective lens
% design, nominal free working distance (in nm), distance image plane from
% cover slip (in nm), wavelength (in nm), emitter position (in nm) with
% z-position from image plane, spot footprint (in nm),axial z-stage range
% (in nm), sampling in pupil with, sampling in image plane, sampling in
% axial direction.
%
% Sjoerd Stallinga, TU Delft

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

parameters.NA = 1.49;
parameters.refmed = 1.518;
parameters.refcov = 1.518;
parameters.refimm = 1.518;
parameters.refimmnom = parameters.refcov;
parameters.fwd = 140e3;
parameters.depth = 0;
parameters.lambda = 552;
parameters.xemit = 0.0;
parameters.yemit = 0.0;
parameters.zemit = 0.0;
parameters.Npupil = 128;
parameters.zrange = [-650 650];
parameters.pixelsize = 80;
parameters.Mx = 31;
parameters.My = 31;
parameters.Mz = 31;

parameters.xrange = parameters.pixelsize*parameters.Mx/2;
parameters.yrange = parameters.pixelsize*parameters.My/2;

% support size for OTF in spatial frequency space
parameters.supportsize = 2.0*parameters.NA/parameters.lambda;
parameters.Nsupport = 256;
parameters.supportsizez = 3.0*(parameters.refimm-sqrt(parameters.refimm^2-parameters.NA^2))/parameters.lambda;
parameters.Nsupportz = 128;
parameters.shiftsupport = [0.5 0.5 0.5];

% aberrations (Zernike orders [n1,m1,A1,n2,m2,A2,...] with n1,n2,... the
% radial orders, m1,m2,... the azimuthal orders, and A1,A2,... the Zernike
% coefficients in lambda rms, so 0.072 means diffraction limit)
% parameters.aberrations = [1,1,0.0; 1,-1,-0.0; 2,0,-0.0; 4,0,0.0; 2,-2,0.0; 2,2,0.0; 4,-2,0.0];

% up to quaternary, all modes 2<n+abs(m)<=10
parameters.aberrations = ...
    [...
    2,-2,0.0; ...
    2, 2,0.0; ...
    3,-1,0.0; ...
    3, 1,0.0; ...
    4, 0,0.0; ...
    3,-3,0.0; ...
    3, 3,0.0; ...
    4,-2,0.0; ...
    4, 2,0.0; ...
    5,-1,0.0; ...
    5, 1,0.0; ...
    6, 0,0.0; ...
    4,-4,0.0; ...
    4, 4,0.0; ...
    5,-3,0.0; ...
    5, 3,0.0; ...
    6,-2,0.0; ...
    6, 2,0.0; ...
    7, 1,0.0; ...
    7,-1,0.0; ...
    8, 0,0.0; ...
    5,-5,0.0; ...
    5, 5,0.0; ...
    6,-4,0.0; ...
    6, 4,0.0; ...
    7,-3,0.0; ...
    7, 3,0.0; ...
    8,-2,0.0; ...
    8, 2,0.0; ...
    9,-1,0.0; ...
    9, 1,0.0; ...
    10,0,0.0];

parameters.aberrations(:,3) =  parameters.aberrations(:,3)*parameters.lambda;

% parameters needed for fixed dipole PSF only: emitter/absorber dipole
% orientation (characterized by angles pola and azim), detection/illumination
% polarization in objective lens back aperture (characterized by angles
% alpha and beta).
parameters.pola = 45.0*pi/180;
parameters.azim = 0.0*pi/180;
parameters.polarizationpupil = false;
parameters.alpha = 45.0*pi/180;
parameters.beta = 45.0*pi/180;

% Bead parameters for convolution with PSF and derivatives, beaddiameter in nm
parameters.bead = true;
parameters.beaddiameter = 45;

% flag for making intermediate plots
parameters.debugmode = 0;

end

